from pyparsing import Forward, Literal, OneOrMore, Word, printables, ZeroOrMore, alphanums, alphas, oneOf

curlyBracesBlock = Forward()
# LCurlyBraces = Literal("{")
# RCurlyBraces = Literal("}")
# curlyBracesBlock << ( (OneOrMore(Word(printables, excludeChars = "{}")))  | 
#     ( LCurlyBraces + ZeroOrMore(curlyBracesBlock) + RCurlyBraces ) )
curlyBracesContent = OneOrMore(Word(printables, excludeChars = "{}"))
curlyBracesBlock << Literal("{") + ZeroOrMore(curlyBracesContent | curlyBracesBlock) + Literal("}")
curlyBracesBlock.setParseAction(lambda location, tokens: [tokens[0], location])

roundBracesBlock = Forward()
#LRoundBraces = Literal("(")
äRRoundBraces = Literal(")")
#roundBracesBlock << ( (OneOrMore(Word(printables, excludeChars = "()")))  | 
#    ( LRoundBraces + ZeroOrMore(roundBracesBlock) + RRoundBraces ) )
roundBracesContent = OneOrMore(Word(printables, excludeChars = "()"))
roundBracesBlock << Literal("(") + ZeroOrMore(roundBracesContent | roundBracesBlock) + Literal(")")
roundBracesBlock.setParseAction(lambda location, tokens: [tokens[0], location])

ID = Word(alphas + "_", alphanums + "_")
qualifiedID = Word(alphas + "_", alphanums + "_.")

pythonRequestsCallPattern = Literal("requests") + Literal(".") + oneOf("get put post delete head") + roundBracesBlock

jsStringChars = Word("\"`'", max = 1)
jsString = jsStringChars

doubleQuoteStringContent = ZeroOrMore(Word(printables, excludeChars = '"') | Literal('\\"'))
singleQuoteStringContent = ZeroOrMore(Word(printables, excludeChars = "'"))
backtickStringContent = ZeroOrMore(Word(printables, excludeChars = "`") | Literal("\\`"))

javaString = Literal('"') + doubleQuoteStringContent + Literal('"')
pythonString = javaString | (Literal("'") + singleQuoteStringContent + Literal("'"))
jsString = pythonString | (Literal("`") + backtickStringContent + Literal("`"))

httpUrlStart = Literal("http://") | Literal("https://")